use "${tmp}/Regfile_nafZE", replace

	
	xtset gp year
	
	destring ZE2010, replace
	
	// define sample 
	egen mlabexid = group(mainlabex)
	qui su mlabexid
	replace mlabexid = r(max) + ZE2010 if mi(mlabexid)
	

	reghdfe ln_eng_sbrut E_post11  if NAF_labex_accept == 1 & ZE_labex_accept == 1 , a(ZE2010#year  gp)  cl(mlabexid)	
	bys gp: egen insampeng = max(e(sample))
	keep if insampeng
	 
	
	// Panel A: Contracting
	
	local row0 = "Panel A: Contracting \\ & Static Coefficient & Pre Trends & Obs. \\"
	preserve
		drop if year == 2004 | year == 2019
		qui prog_gentable E_2005, estimator("reghdfe")  dep(has_cifre) fe("gp ape_n#year ZE2010#year") clust(mlabexid) 
		local row1 = "PhD cosupervision (binary) & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)'  & `=e(Nobs)' obs \\"
		local row2 = "& (`=string(e(se), "%9.4f")') &  & (`=e(Npairs)' pairs) \\ " 
	restore 
	
	preserve
		drop if year < 2008 
		prog_gentable E_2005, estimator("reghdfe")  dep(has_sou) fe("gp ape_n#year  ZE2010#year") clust(mlabexid) 
		local row3 = "Outsourcing R&D to public labs (binary) & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' & `=e(Nobs)' obs \\"
		local row4 = "& (`=string(e(se), "%9.4f")') & & (`=e(Npairs)' pairs) \\ "
	restore 
	
	preserve
		drop if year < 2008 
		prog_gentable E_2005, estimator("reghdfe")  dep(ln_sou) fe("gp ape_n#year ZE2010#year") clust(mlabexid) 
		local row5 = "Outsourcing R&D to public labs (log)& `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' & `=e(Nobs)' obs \\"
		local row6 = "& (`=string(e(se), "%9.4f")') & & (`=e(Npairs)' pairs) \\ "
	restore 
	
	local row7 = "\cr Panel B: Worker Mobility \\ & Static Coefficient & Pre Trends & Obs. \\"
	
	preserve
		drop if  year < 2010
		qui prog_gentable E_2005, estimator("reghdfe")  dep(mobsen) fe("gp ape_n#year ZE2010#year") clust(mlabexid) 
		local row8 = "Transfer of senior academics (binary) & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' & `=e(Nobs)' obs \\"
		local row9 = "& (`=string(e(se), "%9.4f")') & & (`=e(Npairs)' pairs) \\ "
	restore 
	preserve
		drop if  year < 2010
		qui prog_gentable E_2005, estimator("reghdfe")  dep(mobjun) fe("gp ape_n#year ZE2010#year") clust(mlabexid) 
		local row10 = "Transfer of junior academics (binary) & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' & `=e(Nobs)' obs \\"
		local row11 = "& (`=string(e(se), "%9.4f")') & & (`=e(Npairs)' pairs) \\ "
	restore 
	preserve
		drop if  year < 2010
		qui prog_gentable E_2005, estimator("reghdfe")  dep(mobres) fe("gp ape_n#year ZE2010#year") clust(mlabexid) 
		local row12 = "Transfer of researchers (binary) & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' & `=e(Nobs)' obs \\"
		local row13 = "& (`=string(e(se), "%9.4f")') & & (`=e(Npairs)' pairs) \\ "
	restore 	
	preserve
		drop if year == 2019 | year < 2008
		qui prog_gentable E_2005, estimator("reghdfe")  dep(has_jdoc) fe("gp ape_n#year ZE2010#year") clust(mlabexid) 
		local row14 = "Hiring of young PhDs (binary) & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' & `=e(Nobs)' obs \\"
		local row15 = "& (`=string(e(se), "%9.4f")') & & (`=e(Npairs)' pairs) \\ "
	restore 	
	
	local row16 = "\cr Panel C: Startup creation \\ & Static Coefficient & Pre Trends & Obs. \\"
	
	preserve
		qui prog_gentable E_2005, estimator("reghdfe")  dep(newempnolarge) fe("gp ape_n#year ZE2010#year") clust(mlabexid) 
		local row17 = "Creation rate of new plants & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' & `=e(Nobs)' obs \\"
		local row18 = "& (`=string(e(se), "%9.4f")') & & (`=e(Npairs)' pairs) \\ "
	restore 	
		
	preserve
		qui prog_gentable E_2005, estimator("reghdfe")  dep(newempnolarge_newsiren) fe("gp ape_n#year ZE2010#year") clust(mlabexid) 
		local row19 = "- by new firms & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' & `=e(Nobs)' obs \\"
		local row20 = "& (`=string(e(se), "%9.4f")') & & (`=e(Npairs)' pairs) \\ "
	restore 	
	preserve
		qui prog_gentable E_2005, estimator("reghdfe")  dep(newempnolarge_oldsiren) fe("gp ape_n#year ZE2010#year") clust(mlabexid) 
		local row21 = "- by existing firms & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' & `=e(Nobs)' obs \\"
		local row22 = "& (`=string(e(se), "%9.4f")') & & (`=e(Npairs)' pairs) \\ "
	restore 		
	
	preserve
		qui prog_gentable E_2005, estimator("reghdfe")  dep(share_new_ing ) fe("gp ape_n#year ZE2010#year") clust(mlabexid) 
		local row23 = "- with engineers & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' & `=e(Nobs)' obs \\"
		local row24 = "& (`=string(e(se), "%9.4f")') & & (`=e(Npairs)' pairs) \\ "
	restore 		
	
	preserve
		drop if year < 2009
		qui prog_gentable E_2005, estimator("reghdfe")  dep(has_jeu ) fe("gp ape_n#year ZE2010#year") clust(mlabexid) 
		local row25 = "Academic Spin-offs (binary) & `=string(e(coef), "%9.4f")'`=e(star)' & `=e(pt)' & `=e(Nobs)' obs \\"
		local row26 = "& (`=string(e(se), "%9.4f")') & & (`=e(Npairs)' pairs) \\ "
	restore 	
	
	file open myfile using "${outpath}/tableA8.tex", write text replace
	forvalues i = 0/26 {
		file write myfile " `row`i''" _n
	}
	file close myfile